# KW Hash Generator

## Purpose

Generate cryptographic hashes (MD5, SHA1, SHA256) for files to verify integrity. Processes individual files or all files in a directory (non-recursive). Output can be written to stdout or saved to a file. Fast and efficient with large files, using chunked reading to minimize memory usage.

## Requirements

- Python 3.10+
- Windows or Linux
- No external dependencies

## Quick Start

```bash
python kw_hash_generator.py C:\Projects\file.txt --sha256
```

## Usage

```bash
python kw_hash_generator.py <path> [options]
```

### Options

- `path` - File or directory to hash (required, positional)
- `--md5` - Generate MD5 hash
- `--sha1` - Generate SHA1 hash
- `--sha256` - Generate SHA256 hash
- `--all` - Generate all supported hashes (MD5, SHA1, SHA256)
- `--output FILE` - Write results to a file instead of stdout
- `--verbose` - Print progress while hashing (messages go to stderr)
- `--version` - Show tool version and exit

**Note**: At least one hash algorithm flag must be specified (`--md5`, `--sha1`, `--sha256`, or `--all`).

## Output

The tool writes results in this format (pipe-delimited):

```text
<filename> | <ALGORITHM> | <hash>
```

Example:

```text
document.pdf | SHA256 | 5891b5b522d5df086d0ff0b110fbd9d21bb4fc7163af34d08286a2e846f6be03
config.json | MD5 | d41d8cd98f00b204e9800998ecf8427e
```

When `--verbose` is enabled, progress messages are printed to stderr so stdout remains clean for piping or redirection.

## Safety Notes

- **Read-only operation**: The tool never modifies any files; it only reads them
- **Non-recursive directory scanning**: When given a directory, only files directly inside are processed; subdirectories are skipped
- **Symlinks ignored**: Symbolic links are automatically skipped and not followed
- **Graceful error handling**: If a file cannot be read, an error is printed to stderr and processing continues with remaining files
- **Memory efficient**: Files are read in 1MB chunks, allowing large files to be hashed without loading them entirely into memory

## Supported Algorithms

- **MD5**: Fast but cryptographically weak; suitable for checksums and integrity checks, not security
- **SHA1**: Legacy algorithm still widely used; not recommended for security purposes
- **SHA256**: Recommended for security purposes; strong cryptographic hash

## Examples

### Hash a single file with SHA256

```bash
python kw_hash_generator.py C:\Projects\file.txt --sha256
```

### Hash a file with multiple algorithms

```bash
python kw_hash_generator.py C:\Projects\document.pdf --md5 --sha1
```

### Hash a file with all algorithms

```bash
python kw_hash_generator.py C:\Projects\archive.zip --all
```

### Hash all files in a directory (non-recursive)

```bash
python kw_hash_generator.py C:\Projects\MyApp --sha256
```

### Hash files in current directory

```bash
python kw_hash_generator.py . --all
```

### Save output to a file

```bash
python kw_hash_generator.py C:\Projects\MyApp --all --output hashes.txt
```

### Hash with verbose progress messages

```bash
python kw_hash_generator.py C:\Projects\MyApp --sha256 --verbose
```
