# KW GitIgnore Builder

## Purpose

Generate a `.gitignore` file based on selected project types. The tool uses predefined templates for Python, Node, .NET, and PHP projects, and always includes OS junk files and generic logs/temp patterns. Simple, customizable, and prevents accidental overwrites without explicit confirmation.

## Requirements

- Python 3.10+
- Windows or Linux
- No external dependencies

## Quick Start

```bash
python kw_gitignore_builder.py C:\Projects\MyApp --python
```

## Usage

```bash
python kw_gitignore_builder.py <path> [options]
```

### Options

- `path` - Directory where `.gitignore` will be created (required, positional)
- `--python` - Include Python template block (pycache, venv, pytest, mypy, etc.)
- `--node` - Include Node template block (node_modules, npm logs, dist, build, etc.)
- `--dotnet` - Include .NET template block (bin, obj, .vs, .user, .suo, etc.)
- `--php` - Include PHP template block (vendor, phpunit cache, etc.)
- `--all` - Include all language template blocks (Python, Node, .NET, PHP)
- `--force` - Overwrite existing `.gitignore` file without prompting
- `--verbose` - Print detailed information about which blocks are being included
- `--version` - Show tool version and exit

## Output

The tool creates a `.gitignore` file in the target directory. The file always includes:

- **OS junk** (automatically added): `.DS_Store`, `Thumbs.db`, `Desktop.ini`
- **Selected language blocks**: Based on flags provided
- **Generic logs/temp** (automatically added): `*.log`, `*.tmp`, `*.swp`

Blocks are separated by blank lines for readability. With `--verbose`, the tool prints which blocks are being included and the total number of lines generated.

## Safety Notes

- **Protected by default**: Will refuse to overwrite an existing `.gitignore` file unless `--force` is specified
- **No dry-run mode**: The tool writes directly; use `--force` carefully
- **Always includes OS junk and generic patterns**: These are added automatically regardless of language flags
- **Minimal templates**: The tool provides basic, commonly-used patterns; manual customization may be needed for specific projects

## Template Contents

- **OS junk**: `.DS_Store`, `Thumbs.db`, `Desktop.ini`
- **Python**: `__pycache__/`, `*.py[cod]`, `*.pyo`, `.pytest_cache/`, `.mypy_cache/`, `.venv/`, `venv/`
- **Node**: `node_modules/`, `npm-debug.log*`, `yarn-debug.log*`, `yarn-error.log*`, `dist/`, `build/`
- **.NET**: `bin/`, `obj/`, `*.user`, `*.suo`, `.vs/`
- **PHP**: `vendor/`, `.phpunit.result.cache`
- **Generic logs/temp**: `*.log`, `*.tmp`, `*.swp`

## Examples

### Generate .gitignore for a Python project

```bash
python kw_gitignore_builder.py C:\Projects\MyPythonApp --python
```

### Generate .gitignore for a Node project with verbose output

```bash
python kw_gitignore_builder.py C:\Projects\MyNodeApp --node --verbose
```

### Generate .gitignore with multiple language templates

```bash
python kw_gitignore_builder.py C:\Projects\FullStackApp --python --node
```

### Generate .gitignore with all templates

```bash
python kw_gitignore_builder.py C:\Projects\MultiLanguageProject --all
```

### Overwrite existing .gitignore

```bash
python kw_gitignore_builder.py C:\Projects\MyApp --python --force
```

### Generate for current directory

```bash
python kw_gitignore_builder.py . --dotnet --verbose
```
